Attribute VB_Name = "MoveCalloutSet"
'	This is a part of the source code for Pro/DESKTOP.
'	Copyright (C) 1999 Parametric Technology Corporation.
'	All rights reserved.

' ----------------------------------------------------
' MoveCallouts Application
' ----------------------------------------------------
Sub CalloutMovement()

Dim app As Object
Dim api As helm
Const pause As Boolean = False
Const dummy As Boolean = True

Set app = CreateObject("ProDESKTOP.Application")
Set api = app.TakeHelm

app.SetVisible (True)

Dim message As String
message = "Enter Drawing Name (.cvd)" + Chr(13) + Chr(13)
message = message + "( eg. C:\MyDirectory\WheelAssembly.cvd )"
drawingName = InputBox(message, "Callout Movement")

Dim drawing As DrawingDocument
Set drawing = app.OpenDrawing(drawingName)

' --------------------------------------------------
' Prompts the user to select a set or single callout
' and makes a call to MoveCallouts function
' --------------------------------------------------
drawing.SetState (3)        ' Sets the selection state to selecting annotations
MsgBox ("Select Callouts")
api.CommitCalls "GetSelection", dummy

Dim calloutset As ObjectSet
Set calloutset = drawing.GetSelection("Callout")

If (Not calloutset Is Nothing) Then
    message = "Enter integer" + Chr(13) + Chr(13) + "0 : Left      1 : Right" + Chr(13) + "2 : Up       3 : Down" + Chr(13) + "4 : NewLine"
    title = "Movement Direction"
    Dim movement As Integer
    Output = InputBox(message, title, "0")

    If (StrComp(Output, "") And calloutset.GetCount > 0) Then
        movement = Output
        moved = MoveCallouts(calloutset, movement, True)
        
    End If
End If

api.CommitCalls "MoveCallouts", pause

End Sub

' ----------------------------------------------------------
' Moves a set of Callouts, calloutset, as specified by
' movement
' ----------------------------------------------------------
Private Function MoveCallouts(calloutset As ObjectSet, movement As Integer, doIt As Boolean) As Boolean

Dim app As Object
Set app = CreateObject("ProDESKTOP.Application")

' ----------------------------------------------------------
' Create iterator for the Callout set, so as to get objects
' one after the other till the end
' ----------------------------------------------------------

'Create ItClass
dim itCls as ItClass
set itCls = app.GetClass("It")

Set it = itCls.CreateAObjectIt(calloutset)

Dim Callout As aCallout
Set Callout = it.start()

' ----------------------------------------------------------
' Retrieve each callout in the set and move it accroding to
' the input parameter ' movement'
' ----------------------------------------------------------

Do While it.IsActive

    Dim parent As aCalloutGroup
    Set parent = Callout.GetParent("CalloutGroup")
       
    Dim canBeMoved As Boolean
    canBeMoved = parent.MoveCallout(Callout, movement, False)
    
    If (canBeMoved) Then
        MoveCallouts = parent.MoveCallout(Callout, movement, True)
    End If
    
    Set Callout = it.Next()
    
Loop

End Function

